//
//  MPShareViewController.h
//  MPServices
//
//  Created by Oleksii Dykan on 4/16/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import "MPPopoverViewController.h"
#import "MPSharingObject.h"

typedef enum : NSUInteger {
    MPShareViewControllerTypeStandart,
    MPShareViewControllerTypeCreativeKit,
} MPShareViewControllerType;

@interface MPShareViewController : MPPopoverViewController

+ (id)shareViewController;
+ (id)shareViewControllerWithType:(MPShareViewControllerType)type;

@property (nonatomic, assign) BOOL blurredBackground;
@property (readonly, nonatomic, assign) MPShareViewControllerType controllerType;

@property (nonatomic, copy) ShareAsyncPrepareImagesHandler prepareImagesHandler;
@property (nonatomic, copy) void(^exportToImageCallback)(id sender);

@end
